----------------------------------------------------------------------------------------------------------------
-- Default Key Combo Bindings
-- (c) 2004 Relic Entertainment Inc.

-- These combos should NOT be changed by the user.
-- They are here in case the user screws up the key bindings file in Root/KeyBindings/

-- Bindings use format "Control+Shift+A"

-- Valid keys
	--  a - Z   0 - 9
	-- Backspace Tab Enter Escape Space Apostrophe Comma Minus Period Slash Semicolon Equal LBracket Backslash RBracket Grave 
	-- Up Down Left Right Control Shift Alt CapsLock NumLock ScrollLock Insert Delete Home End PageUp PageDown F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 PrintScreen Pause 
	-- MouseLeft MouseRight MouseMiddle MouseTop MouseBottom 
	-- ScreenLeft ScreenRight ScreenTop ScreenBottom 
	-- Numpad0 Numpad1 Numpad2 Numpad3 Numpad4 Numpad5 Numpad6 Numpad7 Numpad8 Numpad9 NumpadMultiply NumpadPlus NumpadSeparator NumpadMinus NumpadPeriod NumpadSlash 
	
bindings_version = 4.1

bindings =
{
	----------------------------------------------------------------------------------------------------------------
	-- SYSTEM COMMANDS
	----------------------------------------------------------------------------------------------------------------
	escape						= "V",
	accept						= "C",
	commandqueue		= "Shift",
	systemmenu			= "F10",
	objectivesmenu		= "F11",
	alliesmenu				= "F12",
	chatmenu				= "Enter",
	chathistory				= "Shift+H",
	pause						= "Pause",
	selectionfocus          = "Apostrophe",
	
	----------------------------------------------------------------------------------------------------------------
	-- TASKBAR COMMANDS
	----------------------------------------------------------------------------------------------------------------
	stop 						= "W",
	move 						= "Q",
	attackmove				= "E",
	attackmelee				= "R",
	build						= "A",
	buildadv					= "",
	attach						= "Control+C",
	attackground			= "S",
	jump						= "V",
	rally							= "Control+Q",
	combatstance			= "Control+F5",
	meleestance			= "Control+F6",
	scuttle						= "Delete",
	infiltrate					= "V",
	unload						= "S",
	deepstrike				= "Control+A",
	reinforce					= "Control+Q",
	leader						= "Control+W",
	cancelconstruction 	= "V",
	rampage					= "V",
	repair						= "S",
	possess					= "A",
	relocate					= "L",
	
	----------------------------------------------------------------------------------------------------------------
	-- ADVANCED TASKBAR COMMANDS
	----------------------------------------------------------------------------------------------------------------
	hq_cycle							= "T",
	military_cycle					= "Control+Space",
	builder_cycle					= "Space",
	research_cycle					= "Shift+R",
	cycle_event_cue				= "Period",
	stance_hold						= "F1",
	stance_stand_ground		= "F2",
	stance_burn					= "F3",
	stance_cease_fire			= "F4",
	stance_attack					= "F5",
	melee_stance_assault	= "F6",
	melee_stance_ranged		= "F7",
	toggle_taskbar				= "Control+H",
	minimap_ping					= "Control+P",
	minimap_ping_toggle		= "Control+E",
	toggle_overwatch			= "Control+O",
	cancel_overwatch			= "Control+K",
	
	----------------------------------------------------------------------------------------------------------------
	-- MULTIPLE SELECTION HOTKEYS
	----------------------------------------------------------------------------------------------------------------
	focus_primary_selection 	= "Control+Tab",
	next_primary_selection  	= "Tab",
	prev_primary_selection  	= "Shift+Tab",
	remove_selection_modifier  = "Control",		-- checked with mouse click (removes clicked items from selection) -- note: must only be one key
	crop_selection_modifier  	= "Shift",			-- checked with mouse click	(selects all units of the same type) -- note: must only be one key
		
	----------------------------------------------------------------------------------------------------------------
	-- DATA CONTEXT HOTKEYS
	----------------------------------------------------------------------------------------------------------------
	
	-- BUILDINGS FOR MARINES
	marine_hq								= 	"Q",
	marine_artefact						=	"D",
	marine_armoury						= 	"A",
	marine_chapel							=	"W",
	marine_generator					= 	"R",
	marine_listening_post				=	"E",
	marine_orbital_relay				= 	"C",
	marine_temp_drop_building	=	"D",
	marine_thermo_generator		= 	"F",
	marine_bolter_turret				=	"Z",
	marine_machine_cult				=	"S",
	marine_mine_field					=	"X",

	-- BUILDINGS FOR CHAOS 
	chaos_hq								=	"Q",
	chaos_sacrificial_circle			=	"D",
	chaos_armoury					=	"A",
	chaos_temple						=	"W",
	chaos_generator					=	"R",
	chaos_listening_post			=	"E",
	chaos_greater_circle			=	"C",
	chaos_thermo_generator	=	"F",
	chaos_bolter_turret			=	"Z",
	chaos_machine_pit				=	"S",
	chaos_mine_field					=	"X",

	-- BUILDINGS FOR ORKS
	ork_hq								=	"Q",
	ork_waagh_banner			=	"A",
	ork_pile_o_guns				=	"S",
	ork_boy_hut					=	"W",
	ork_generator					=	"R",
	ork_listening_post			=	"E",
	ork_big_generator			=	"F",
	ork_mek_shop					=	"D",
	ork_mine_field					=	"Z",

	-- BUILDINGS FOR ELDAR
	eldar_hq									=	"Q",
	eldar_aspect_portal				=	"W",
	eldar_soul_shrine					=	"S",
	eldar_webway_gate				=	"A",
	eldar_generator						=	"R",
	eldar_listening_post				=	"E",
	eldar_advanced_generator		=	"F",
	eldar_support_platform			=	"Z",
	eldar_support_portal				=	"D",
	eldar_mine_field						=	"X",

    -- BUILDINGS FOR IMPERIAL GUARD
	guard_hq								    = 	"Q",
	guard_tactica						    = 	"A",
	guard_infantry							=	"W",
	guard_generator					    = 	"R",
	guard_listening_post				=	"E",
	guard_mars_command			= 	"D",
	guard_thermo_generator		= 	"F",
	guard_bolter_turret				=	"Z",
	guard_mechanized_command =	"S",
	guard_mine_field 					=	"X",
	
	-- TROOPERS FOR MARINES
	marine_servitor						=	"Q",
	marine_dreadnought				=	"E",
	marine_dreadnought_hellfire	=	"R",
	marine_force_commander		=	"A",
	marine_land_speeder				=	"W",
	marine_librarian						=	"W",
	marine_skull_probe					=	"Z",
	marine_scout							=	"W",
	marine_apothecary					=	"Q",
	marine_assault_marine			=	"W",
	marine_sergeant						=	"S",
	marine_space_marine				=	"Q",
	marine_terminator					=	"E",
	marine_assault_terminator		=	"R",	
	marine_land_raider					=	"D",
	marine_predator						=	"S",
	marine_rhino							=	"Q",
	marine_whirlwind					=	"A",
	marine_chaplain					=	"R",

	-- TROOPERS FOR CHAOS
	chaos_bloodthirster_research			=	"W",
	chaos_cultist						=	"W",
	chaos_defiler						=	"W",
	chaos_horrors						=	"Q",
	chaos_lord							=	"A",
	chaos_marines					=	"Q",
	chaos_raptors						=	"W",
	chaos_possessed				=	"W",
	chaos_obliterator				=	"Q",
	chaos_predator					=	"E",
	chaos_aspiring_champion	=	"A",
	chaos_rhino							=	"Q",
	chaos_heretic						=	"Q",
	chaos_sorcerer					=	"R",	
	chaos_khorne_berserker	=	"R",	

	-- TROOPERS FOR ORKS
	ork_nobs					=	"R",
	ork_shoota_boyz	=	"W",
	ork_slugga_boyz		=	"Q",
	ork_stormboyz		=	"E",
	ork_tankbustas		=	"F",
	ork_grots					=	"W",
	ork_killa_kan			=	"E",
	ork_bad_dok			=	"E",
	ork_mek_boy			=	"A",
	ork_nob_leader		=	"L",
	ork_warboss			=	"R",
	ork_looted_tank		=	"R",
	ork_squiggoth			=	"A",
	ork_trukk					=	"Q",	
	ork_wartrak				=	"W",
	ork_armored_nob		=	"F",
	
	-- TROOPERS FOR ELDAR
	eldar_bonesinger							=	"Q",
	eldar_grav_platform_laser				=	"Q",
	eldar_grav_platform_brightlance	=	"W",
	eldar_avatar									=	"S",
	eldar_farseer									=	"A",
	eldar_warlock									=	"W",
	eldar_warlock_seer							=	"E",
	eldar_falcon_grav_tank					=	"Q",
	eldar_fire_prism								=	"R",
	eldar_vyper										=	"W",
	eldar_wraithlord								=	"E",
	eldar_banshee								=	"W",
	eldar_banshee_exarch					=	"H",
	eldar_dark_reapers							=	"E",	
	eldar_dark_reaper_exarch				=	"D",
	eldar_guardians								=	"W",
	eldar_rangers									=	"Q",
	eldar_warp_spiders						=	"R",		
	eldar_warp_spiders_exarch			=	"W",		
	eldar_fire_dragon							=	"F",	
	
	-- TROOPERS FOR IMPERIAL GUARD
	guard_enginseer						=	"W",
	guard_guardsmen				    =	"Q",
	guard_heavy_weapon          	=	"H",
	guard_command_squad			=	"A",
	guard_commissar					=	"A",
	guard_priest							=	"D",
    guard_psyker							=	"S",
	guard_kasrkin							=	"E",
	guard_ogryn							=	"R",
	guard_basilisk							=	"E",
	guard_sentinel						=	"Q",
	guard_hellhound						=	"W",
	guard_assassin						=	"F",
	guard_baneblade					=	"Q",	
	guard_leman_russ					=	"R",
	guard_chimera						=	"A",
	guard_sergeant						=	"A",
	
	-- WEAPON UPGRADES FOR MARINES
	marine_assault_cannon	=	"Control+S",
	marine_flamer					=	"Control+A",
	marine_heavy_flamer		=	"Control+A",
	marine_heavy_bolter		=	"Control+S",
	marine_lascannon_1		=	"Control+S",
	marine_lascannon_2		=	"Control+Z",
	marine_lascannon_twin	=	"Control+A",
	marine_missile_launcher	=	"Control+X",
	marine_plasma_gun		=	"Control+Z",
	marine_sniper_rifle			=	"Control+S",
	marine_missile_launcher_turret = "Q",

	-- WEAPON UPGRADES FOR CHAOS 	
	chaos_flamer						=	"Control+A",
	chaos_heavy_flamer			=	"Control+A",
	chaos_grenade_launcher	=	"Control+S",
	chaos_heavy_bolter			=	"Control+A",
	chaos_lascannon_1				=	"Control+S",
	chaos_lascannon_2				=	"Control+Z",
	chaos_lascannon_twin		=	"Control+A",
	chaos_missile_launcher		=	"Control+X",
	chaos_plasma_gun				=	"Control+Z",
	chaos_missile_launcher_turret = "Q",
	
	-- WEAPON UPGRADES FOR ORKS
	ork_big_shoota					=	"Control+A",
	ork_kustom_shoota			=	"S",
	ork_bomb_chucka				=	"Control+A",
	ork_burna							=	"Control+S",
	ork_mega_blasta				=	"M",
	ork_power_klaw					=	"Control+A",
	ork_rokkit_launcha				=	"Control+Z",
	ork_rokkit_launcha_twin		=	"Control+A",
	ork_shoota							=	"S",
	ork_zzzap_gun					=	"P",
		
	-- WEAPON UPGRADES FOR GUARD
	guard_grenade_launcher	=	"Control+A",
	guard_plasma_gun				=	"Control+S",

	-- WEAPON UPGRADES FOR ELDAR
	eldar_bright_lance			=	"Control+A",
	eldar_dcannon				=	"Q",
	eldar_missile_launcher	=	"Control+A",
	eldar_scatter_laser			=	"S",
	eldar_shuriken_cannon	=	"S",
	eldar_starcannon			=	"Control+A",
	eldar_witchblade_seercouncil			= "Control+A",
		
	-- BUILDINGS
	
	-- RESEARCH FOR MARINES
	marine_accuracy_research_1					=	"S",
	marine_accuracy_research_2					=	"S",
	marine_force_commander_research_1	=	"Z",
	marine_force_commander_research_2	=	"Z",
	marine_daemon_hammer_research		=	"D",
	marine_frag_grenade_research				=	"Z",
	marine_health_research_1						=	"A",
	marine_health_research_2						=	"A",
    marine_commander_health_research_1	=	"A",
	marine_commander_health_research_2	=	"A",
	marine_librarian_research_1					=	"X",
	marine_librarian_research_2					=	"X",
	marine_max_weapons_research			=	"Q",
	marine_melta_bomb_research				=	"X",
	marine_power_research_1						=	"Q",
	marine_power_research_2						=	"Q",	
	marine_requisition_research_1				=	"A",
	marine_requisition_research_2				=	"A",
	marine_scout_infiltration_research			=	"C",
	marine_smoke_launcher_research			=	"X",		
	marine_squad_cap_research					=	"A",		
	marine_vehicle_cap_research					=	"S",
	marine_sergeant_melee_research_1		=	"Z",
	marine_sergeant_melee_research_2		=	"Z",		
	marine_sergeant_ranged_research		=	"X",
	marine_personalteleporter_research		=	"Z",
	marine_heavy_armor_deployment			=  "Z",
	marine_sniper_rifle			=  "V",
	
	-- RESEARCH FOR CHAOS
	chaos_ranged_research_1						=	"R",
	chaos_lord_research_1							=	"X",
	chaos_lord_research_2							=	"X",
	chaos_frag_grenade_research				=	"Z",
	chaos_health_research_1						=	"S",
	chaos_health_research_2						=	"S",
	chaos_commander_health_research_1	=	"Z",
	chaos_commander_health_research_2	=	"Z",
	chaos_sorcerer_research_1					=	"C",
	chaos_sorcerer_research_2					=	"C",
	chaos_max_weapons_research				=	"Q",
	chaos_power_research_1						=	"Q",
	chaos_power_research_2						=	"Q",	
	chaos_requisition_research_1				=	"A",
	chaos_requisition_research_2				=	"A",
	chaos_infiltration_research						=	"V",
	chaos_smoke_launcher_research			=	"X",		
	chaos_squad_cap_research					=	"A",		
	chaos_vehicle_cap_research					=	"S",		
	chaos_champion_melee_research_1		=	"Z",
	chaos_champion_melee_research_2		=	"Z",		
	chaos_champion_ranged_research			=	"X",	
	chaos_furious_charge_research				=	"Q",	
	chaos_raptor_speed_research				=	"X",
	chaos_accuracy_upgrade_research_1	=	"A",
	chaos_accuracy_upgrade_research_2	=	"A",
	chaos_personalteleporters						=	"A",
	chaos_possessed_daemon_fire_research 			= "S",
	chaos_possessed_daemon_flight_research 		= "S",
	chaos_possessed_daemon_mutation_research = "A",
	chaos_possessed_daemon_talons_research 	= "F",
	chaos_projectiles = "Z",

	-- RESEARCH FOR ORKS
	ork_big_squad_research							=	"B",
	ork_big_shoota_research						=	"W",
	ork_burna_research								=	"E",
	ork_eavy_armour_research					=	"Z",
	ork_extra_armour_research					=	"Z",
	ork_mega_blasta_research						=	"M",
	ork_mekboy_melee_research					=	"M",
	ork_mekboy_ranged_research				=	"R",
	ork_morechoppy_research_1					=	"A",
	ork_morechoppy_research_2					=	"A",
	ork_moredakka_research_1					=	"Q",
	ork_moredakka_research_2					=	"Q",
	ork_moreshooty_research_1					=	"W",
	ork_moreshooty_research_2					=	"W",
	ork_powerclaw_research						=	"S",	
	ork_rokkit_research								=	"R",
	ork_tougherorks_research_1					=	"T",
	ork_tougherorks_research_2					=	"T",
	ork_warboss_ranged_research				=	"R",		
	ork_tougherbosses_research_1				=	"X",
	ork_tougherbosses_research_2				=	"X",
	ork_kustom_force_field_research			=	"Z",
	ork_tankbustin_kit_research					=	"C",
	ork_kustom_tellyporta_research				=	"Z",
	ork_eavy_armor_boyz_research				=	"Z",
	ork_speed_boost_research					=	"X",
	ork_speed_boost_stormboyz_research	=	"V",
	ork_waaaaagh_research						=	"W",
	ork_research_stikk_bombs						=	"D",
	ork_power_research_1							=	"Q",
	ork_power_research_2							=	"Q",
	ork_requisition_research_1						=	"A",
	ork_requisition_research_2						=	"A",
	ork_research_grot_infiltration 				= "A",
	ork_research_tankbustabombs 				= "F",

	-- RESEARCH FOR ELDAR
	eldar_ability_research						=	"A",
	eldar_accuracy_research					=	"E",
	eldar_exarch_ability_research_1	=	"Z",
	eldar_exarch_ability_research_2	=	"C",
	eldar_farseer_ability_research_1	=	"A",
	eldar_farseer_ability_research_2	=	"S",
	eldar_farseer_ability_research_3	=	"S",
	eldar_health_research					=	"C",
	eldar_vehicle_ability_research		=	"Z",
	eldar_warlock_ability_research_1	=	"A",
	eldar_warlock_ability_research_2	=	"W",
	eldar_warlock_ability_research_3	=	"R",
	eldar_shroud_ability_research		=	"C",
	eldar_fleet_of_foot_research 			= "Z",
	eldar_bonesinger_ability_research_3 = "X",
	eldar_ranger_infiltration_research 		= "Z",
	eldar_haywire_grenade_research 		= "V",
	webway_gate_healing_research 		= "Z",
	eldar_webway_gate_relocation_research = "X",
	eldar_plasma_grenade_research 				= "C",
	eldar_bonesinger_ability_research_1 		= "T",
	eldar_power_research_1 			= "Q",
	eldar_power_research_2 			= "Q",
	eldar_requisition_research_1 		= "A",
	eldar_requisition_research_2 		= "A",
	eldar_tier2_research 					= "Q",
	eldar_research_farseerhealth_1 = "V",
	eldar_research_farseerhealth_2 = "V",
	eldar_research_infantryaccuracy_1 = "X",
	eldar_research_infantryaccuracy_2 = "X",
	eldar_researchinfantryhealth_1 = "C",
	eldar_researchinfantryhealth_2 = "C",
	eldar_annihilate_the_enemy = "Q",

	-- RESEARCH FOR GUARD
	guard_guardsman_morale						=	"Q",
	guard_guardsman_morale_2					=	"S",
	guard_research_command_squad_size	=	"R",
	guard_research_kasrkin_armor				=	"X",
	guard_research_kasrkin_speed				=	"Z",
	guard_upgrade_guardsmen_health		=	"W",
	guard_upgrade_guardsmen_range		=	"A",
	guard_upgrade_ogryn_melee					=	"C",
	guard_upgrade_power_1						=	"Q",
	guard_upgrade_power_2						=	"Q",
	guard_upgrade_requisition_1					=	"A",
	guard_upgrade_requisition_2					=	"A",
	guard_upgrade_weapon_specialization	=  "F",
	guard_full_scale_war 								=  "Z",
	
	-- ADDONS FOR MARINES
	marine_hq_addon_1			=	"Z",
	marine_hq_addon_2			=	"Z",
	marine_listening_post_1		=	"Q",
	marine_listening_post_2		=	"W",
	marine_turret_addon			=	"Q",
	
	-- ADDONS FOR CHAOS
	chaos_hq_addon_1						=	"Z",
	chaos_hq_addon_2						=	"Z",
	chaos_listening_post_1				=	"Q",
	chaos_listening_post_2				=	"W",
	chaos_turret_addon					=	"Q",
		
	-- ADDONS FOR ELDAR
	eldar_banshee_aspect_stone			=	"W",
	eldar_dark_reaper_aspect_stone	=	"E",
	eldar_fire_prism_aspect_stone		=	"R",
	eldar_fire_dragon_aspect_stone	=	"F",
	eldar_vyper_aspect_stone				=	"W",
	eldar_warp_spider_aspect_stone	=	"R",
	eldar_wraithlord_aspect_stone		=	"E",
	eldar_support_platform_addon		=	"Q",
	eldar_listening_post_1					=	"Q",
	eldar_listening_post_2					=	"W",
		
	-- ADDONS FOR ORKS
	ork_hq_addon										=	"Z",
	ork_waagh_banner_gunz_1				=	"Q",
	ork_waagh_banner_gunz_2				=	"Q",
	ork_waagh_banner_orkcap				=	"U",
	ork_waagh_banner_popgrowth			=	"U",
	ork_waagh_banner_supportgrowth	=	"U",	
	ork_listening_post_1							=	"Q",
	ork_listening_post_2							=	"W",

	-- ADDONS FOR IMPERIAL GUARD
	addon_guard_basilisk_depot				=	"E",
	addon_guard_heavy_weapon_vault	=	"H",
	addon_guard_hellhound_depot			=	"W",
	addon_guard_hq_1								=	"Z",
	addon_guard_hq_2								=  "Z",
	addon_guard_kasrkin_quarters			=	"E",
	addon_guard_leman_russ_depot		=	"R",
	addon_guard_list_post_1					=	"Q",
	addon_guard_list_post_2					=	"W",
	addon_guard_ministorum_temple		=  "D",
	addon_guard_ogryn_quarters			=  "R",
	addon_guard_sentinel_depot				=  "Q",
	addon_guard_telepathica_temple		=  "S",
	addon_guard_vindicare_temple			=  "F",
	guard_turret_addon							=	"Q",
	
	-- ABILITIES FOR MARINES
	marine_battlecry							=	"Z",
	marine_demoralize						=	"A",	
	marine_frag_grenades				=	"A",
	marine_machine_spirit				=	"A",
	marine_melta_bombs					=	"A",
	marine_orbital_bombardment		=	"X",
	marine_rally									=	"S",	
	marine_sabotage						=	"A",
	marine_smite								=	"Z",
	marine_smoke_launchers			=	"A",	
	marine_weaken_resolve				=	"X",
	marine_word_of_emperer			=	"C",
	
	-- ABILITIES FOR CHAOS
	chaos_chains						=	"X",
	chaos_corruption					=	"C",
	chaos_daemon_strength	=	"Z",
	chaos_doom_bolt				=	"Z",
	chaos_force_labor				=	"Z",
	chaos_frag_grenades			=	"A",	
	chaos_furious_rage				=	"S",
	chaos_smoke_launchers		=	"A",
	chaos_speed_fiends			=	"A",

	-- ABILITIES FOR ELDAR
	eldar_bonesong					=	"A",
	eldar_eldritch_storm			=	"V",
	eldar_psychic_storm			=	"Z",
	eldar_embolden					=	"D",
	eldar_entanglement			=	"F",
	eldar_fleetoffoot					=	"A",	
	eldar_fortune						=	"F",
	eldar_graviticboost				=	"Z",
	eldar_haywire_bombs			=	"S",
	eldar_guide							=	"C",
	eldar_mind_war					=	"X",
	eldar_plasma_grenades		=	"S",
	eldar_warshout					=	"S",
	eldar_wraithtomb				=	"C",	
	eldar_shroud_ability			=	"C",

	-- ABILITIES FOR ORKS
	ork_fightabomba_strafe		=	"F",
	ork_fightin_juice					=	"Z",
	ork_gimme_boyz_mek			=	"M",
	ork_gimme_boyz_warboss	=	"W",
	ork_pop_growth					=	"P",
	ork_power_of_waagh			=	"Z",	
	ork_stikkbombs					=	"S",
	ork_tankbusta_bombs		=	"A",
	ork_superstik_bomb			= "X",
	ork_turbo_boost					=	"A",
	ork_waaaaagh					=	"A",
	ork_tank_zzappa				= "Z",
	ork_power_surge = "Z",

	-- ABILITIES FOR IMPERIAL GUARD
	guard_assassin_assassinate		=	"Z",
	earthshaker_round						=	"Z",
	guard_commissar_execute			=	"Z",
	guard_kasrkin_frag_grenades	=	"A",
	guard_priest_fanatical				=	"X",
	guard_psyker_lighting_arc			=	"C",	
	guard_psyker_strip_soul				=	"V",
	guard_strafing_run						=	"Z",

	--Entity attack range
	attack										= "A",
	
	}
